/*
 * By: James Sheets
 * For: CIS 421
 * Due: 12/20/06
 * Req: Java 5 (v1.5) runtime, or higher
 * Purpose: Simulate a database equijoin hash algorithm using flat files
 *          upon user selectable tuple fields
 *
 * This program will open two files, each of which represents a database.
 * These files will be called R1 and R2
 * 
 * Each line in a file will represent a tuple, with the tuples being
 * space-delimited in the file
 *
 * The number of fields in each tuple is defined in R1_fields and R2_fields
 *
 * The user is queried to select a field from each of the databases.  The
 * program will then perform a hashing function on one of the files using the
 * field selected for it, and storing the results in files ("buckets"). Then,
 * the second file is hashed against it's selected field, which is used to
 * look up the data stored in the buckets.  Any found values are equijoined, 
 * and displayed to the user
 */
 

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import java.io.*;
import javax.swing.BorderFactory; 
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.border.EtchedBorder;



/*
 * Main Program
 */
public class hashing implements ActionListener
{
   
   
   
   /*
    * Globals
    */
   private JTextArea output;
   private JComboBox R1_selector;
   private JComboBox R2_selector;
   File R1 = new File("r1.txt");
   File R2 = new File("r2.txt");
   int R1_fields = 3;
   int R2_fields = 4;
   int Buckets = 10;
   
   
   
   /*
    * Program entry-point
    */
   public static void main(String[] args)
   {
      // Instantiate the program inside a GUI-update thread
      javax.swing.SwingUtilities.invokeLater(new Runnable() {
         public void run() {
            JFrame.setDefaultLookAndFeelDecorated(true);
            hashing h = new hashing();
         }
      });
   }
   
   
   
   /*
    * Default constructor
    */
   public hashing()
   {
      // Fill arrays with possible fields we can select for each file
      String[] R1_opt = new String[R1_fields];
      for (int i=1; i <= R1_fields; i++) R1_opt[i-1] = "a"+i;
      String[] R2_opt = new String[R2_fields];
      for (int i=1; i <= R2_fields; i++) R2_opt[i-1] = "b"+i;
      
      // Setup frame
      JFrame frame = new JFrame("Database Hash-Join");
      frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
      
      // Setup output windo
      output = new JTextArea("Results...");
      output.setBorder( BorderFactory.createEtchedBorder(EtchedBorder.LOWERED) );
      
      // Setup start button
      JButton button = new JButton("Run");
      button.addActionListener(this);
      
      // Setup tuple-field selction
      R1_selector = new JComboBox(R1_opt);
      R1_selector.setBorder( BorderFactory.createTitledBorder( BorderFactory.createEtchedBorder(EtchedBorder.LOWERED), "R1 Field") ); 
      R2_selector = new JComboBox(R2_opt);
      R2_selector.setBorder( BorderFactory.createTitledBorder( BorderFactory.createEtchedBorder(EtchedBorder.LOWERED), "R2 Field") ); 
      JPanel p1 = new JPanel(new GridLayout(1,2));
      p1.add(R1_selector);
      p1.add(R2_selector);
      
      // Add everything to the main window and display
      frame.getContentPane().add( p1, BorderLayout.NORTH );
      frame.getContentPane().add( new JScrollPane(output), BorderLayout.CENTER );
      frame.getContentPane().add( button, BorderLayout.SOUTH );
      frame.setSize( new Dimension(400,500) );
      frame.setVisible(true);
   }
   
   
   
   /*
    * Creates our bucket files, returns them in an array
    */
   public PrintWriter[] createBuckets()
   {
      // Create file array
      PrintWriter[] files = new PrintWriter[Buckets];
      
      // Loop to create files
      for (int i=0; i < Buckets; i++)
      {
         try {
            // Create a new file (if doesn't exist)
            String fileName = "bucket"+i;
            File f = new File(fileName);
            f.createNewFile();
            f.deleteOnExit();
            // Create print writer, which will clear the contents
            files[i] = new PrintWriter(f);
         } catch (Exception e) {
            System.err.println(e);
         }
      }
      
      // Return file array
      return files;
   }
   
   
   
   /*
    * Parse the tuple, finding the value of the field at the position selected
    * by the user in the combo box.  Calculate the hash, and return it
    */
   public int calculateHash(JComboBox jcb, String tuple)
   {
      StringTokenizer st = new StringTokenizer(tuple);
      
      // Iterate through the tokens until we get to the token we want
      int i = 0;
      while (st.hasMoreTokens())
      {
         // Next token
         String token = st.nextToken();
         
         // This is the tuple field we want to hash against
         if (i == jcb.getSelectedIndex())
         {
            try {
               // Calculate it's hash
               int val = Integer.parseInt(token);
               int hash = val % Buckets;
               // Return the value
               return hash;
            } catch (Exception e) { 
               //
            }
         }
         
         // Increament counter
         i++;
      }
      
      // this is bad
      return -1;
   }
   
   
   
   /*
    * Write out the tuple to the bucket file
    */
   public void writeBucket(PrintWriter bucket, String tuple)
   {
      try {
         bucket.print( tuple + "\n" );
         bucket.flush();
         
      } catch (Exception e) {
         System.err.println(e);
      }
   }
   
   
   
   /*
    * Looks to see if there's a bucket for the given hash file.  If it exists,
    * it sees if there are any tuples in it.  If there are, it Equijoins each
    * with the input tuple, and prints it to the JTextArea
    */
   public void joinTuple(JComboBox jcb, int hash, String tuple)
   {
      try {
         // Get the file bucket for this hash file
         File f = new File("bucket"+hash);
         
         // Make sure hte file exists
         if (f.exists())
         {
            // Read the file
            FileInputStream fis = new FileInputStream(f);
            BufferedReader br = new BufferedReader( new InputStreamReader(fis) );
            
            // Loop through any tuples found
            while ( br.ready() )
            {
               // Join the tuples
               String equiJoinTuple = "";
               
               // Tuple found: tokenize the tuple and iterate through it
               StringTokenizer st = new StringTokenizer( br.readLine() );
               
               // Iterate through the tokens until we get to the token we want
               int i = 0;
               while (st.hasMoreTokens())
               {
                  // Next token
                  String token = st.nextToken();
                  
                  // Add every token except the one we joined on
                  if (i != jcb.getSelectedIndex())
                  {
                     equiJoinTuple += token + " ";
                  }
                  
                  // Increament counter
                  i++;
               }
               
               // Append tuple from second file
               equiJoinTuple += tuple + "\n";
               // Print the tuple to the output area
               output.append( equiJoinTuple );
            }
            
            // Close the reader
            br.close();
         }
         
      } catch (Exception e) {
         System.err.println(e);
      }
   }
   
   
   
   /*
    * Event-listener: triggers when the "Run" button is pushed
    */
   public void actionPerformed(ActionEvent event) 
   {
      // Create buckets
      PrintWriter[] files = createBuckets();
      
      // Clear the output screen
      output.setText("");
      
      try {
         
         // Create file streams from the files
         FileInputStream fisR1 = new FileInputStream(R1);
         FileInputStream fisR2 = new FileInputStream(R2);
         
         // Create buffered reader streams, so we can fetch lines (tuples)
         BufferedReader brR1 = new BufferedReader( new InputStreamReader(fisR1) );
         BufferedReader brR2 = new BufferedReader( new InputStreamReader(fisR2) );
         
         // Calculate hash for each tuple in first file, and populate
         // the corresponding bucket with that tuple's values
         while ( brR1.ready() )
         {
            String tuple = brR1.readLine();
            int hash = calculateHash( R1_selector, tuple );
            writeBucket(files[hash], tuple );
         }
         // Close the files
         for (int i=0; i < files.length; i++) files[i].close();
         
         
         // Calculate hash for each tuple in second file, and attempt to
         // equijoin it with any bucketed values
         while ( brR2.ready() )
         {
            String tuple = brR2.readLine();
            int hash = calculateHash( R2_selector, tuple );
            joinTuple(R1_selector, hash, tuple);
         }
         
         // Close the streams
         brR1.close();
         brR2.close();

      } catch (Exception e) {
         System.err.println(e);
      }
   }
   
   
   
}